#!/bin/bash

#1.VARIABLES FOR COLORS:

RED_COLOR=$'\033[31;1m'
GREEN_COLOR=$'\033[32;1m'
CYAN_COLOR=$'\033[36;1m'
DEFAULT_COLOR=$'\033[0m'

#2.INPUT DOMAIN NAME:

printf "%sTYPE THE DOMAIN NAME AND WATCH THE MAGIC HAPPEN!%s\\n" "$GREEN_COLOR" "$DEFAULT_COLOR"

#2.1.CHECK IF INPUT DOMAIN EXISTS AND ASK FOR INPUT UNTIL EXISTING DOMAIN IS PROVIDED:

current_user=$(whoami)
counter=0

while [ -z "$doc_root" ]; do

  if [ "$counter" != 0 ]; then

    printf "%sINVALID DOMAIN! TYPE THE DOMAIN AGAIN:%s\\n" "$RED_COLOR" "$DEFAULT_COLOR"

  fi

  read -e -r -p $'\e[36mDomain/Subdomain:\e[0m ' input_domain;

  #2.1.1.CONVERT INPUT TO LOWERCASE:

  input_domain="${input_domain,,}"

  #2.1.2.REMOVE ANY '/' AT THE END OF THE INPUT:

  last_char="${input_domain: -1}"

  while [ "$last_char" = '/' ]; do

  input_domain=${input_domain%?};
  last_char="${input_domain: -1}"

  done

  sub_folder=$( echo "${input_domain}" | cut -d '/' -s -f 2- )
  domain_name=$( echo "$input_domain" | cut -d '/' -f 1 )

  if [ "$current_user" = 'root' ]; then

    cpanel_user=$( /scripts/whoowns "$domain_name" )

    if [ ! -z "$cpanel_user" ]; then

      doc_root=$( uapi --user="$cpanel_user"  DomainInfo single_domain_data domain="$domain_name" | grep 'documentroot:' | cut -d ' ' -f 6 )

    fi

  else

    doc_root=$( uapi DomainInfo single_domain_data domain="$domain_name" | grep 'documentroot:' | cut -d ' ' -f 6 )

  fi

  if [ ! -z "$sub_folder" ]; then

    doc_root=${doc_root}/${sub_folder}

  fi

  ((counter++))

done

#3.GET CPANEL USERNAME AND CUT IT TO 8 CHARS IF LONGER:

if [ -z "$cpanel_user" ]; then

  cpanel_user=$( uapi DomainInfo single_domain_data domain="$domain_name" | grep 'user:' | cut -d ' ' -f 6 )

fi

cpanel_user_length=${#cpanel_user}

if [ "$cpanel_user_length" -ge 8 ]; then

  cpanel_user_prefix=$( echo "$cpanel_user" | cut -c 1-8 )

else 
 
  cpanel_user_prefix=$( echo "$cpanel_user" )

fi

#4.CREATE DATABASE (CHECK IF DATABASE EXISTS AND IF YES CHANGE DATABASE_PREFIX UNTIL NEW DB CAN BE CREATED):

db_prefix_length=1
db_name_status=0
while [ "$db_name_status" -eq 0 ]; do

#4.1 GET DATABASE NAME PREFIX:

  db_prefix_length=$((db_prefix_length+1))
  db_prefix_value=$( echo "$domain_name" | cut -c 1-"$db_prefix_length" )

#4.2 REMOVE ALL INSTANCES OF '.' IN DATABASE NAME:

  db_name=${cpanel_user_prefix}_${db_prefix_value}
  db_name=${db_name//./}

#4.3 CREATE THE DATABASE:
  if [ "$current_user" = 'root' ]; then

    db_name_status=$( uapi --user="$cpanel_user" Mysql create_database name="$db_name" | grep 'status:' | cut -d ' ' -f 4 )
  
  else

    db_name_status=$( uapi Mysql create_database name="$db_name" | grep 'status:' | cut -d ' ' -f 4 )

  fi

done

printf "%sDATABASE CREATED.%s\\n" "$GREEN_COLOR" "$DEFAULT_COLOR"

db_pass=$( < /dev/urandom tr -dc 'a-zA-Z0-9' | fold -w 20 | head -n 1 )

#5.CREATE DATABASE USER, ADD PRIVILIGES AND OUTPUT IF USER IS CREATED SUCCESSFULLY:

if [ "$current_user" = 'root' ]; then

  db_user_status=$( uapi --user="$cpanel_user" Mysql create_user name="$db_name" password="$db_pass" | grep 'status:' | cut -d ' ' -f 4 )
  uapi --user="$cpanel_user" Mysql set_privileges_on_database user="$db_name" database="$db_name" privileges=ALL%20PRIVILEGES > /dev/null 2>&1

else

  db_user_status=$( uapi Mysql create_user name="$db_name" password="$db_pass" | grep 'status:' | cut -d ' ' -f 4 )
  uapi Mysql set_privileges_on_database user="$db_name" database="$db_name" privileges=ALL%20PRIVILEGES > /dev/null 2>&1

fi

if [ "$db_user_status" -eq 1 ]; then

  printf "%sDATABASE USER CREATED.%s\\n" "$GREEN_COLOR" "$DEFAULT_COLOR"

else

  printf "%sDATABASE USER NOT CREATED!%s\\n" "$RED_COLOR" "$DEFAULT_COLOR"

fi

#CREATE FOLDER IF IT DOES NOT EXIST:

if [ ! -d "$doc_root" ]; then

  if [ "$current_user" = 'root' ]; then
  
    sudo -u "$cpanel_user" mkdir -p "$doc_root"
  
  else
  
    mkdir -p "$doc_root"
  
  fi
fi

#MOVE TO DOCUMENT ROOT:
 
current_path=$(pwd)
 
if [ "$current_path" != "$doc_root" ]; then
 
 cd "$doc_root" || return

fi

if [ "$current_user" = 'root' ]; then
 
#INSTALL WP_CLI IF NOT ALREADY INSTALLED:
 
  if [ ! -f /user/local/bin/wp ]; then
  
    curl -s -O https://raw.githubusercontent.com/wp-cli/builds/gh-pages/phar/wp-cli.phar 2>/dev/null && chmod +x wp-cli.phar && mv wp-cli.phar /usr/local/bin/wp
  
    if [ -f /user/local/bin/wp ]; then
  
      printf "%sWP CLI INSTALLED.%s\\n" "$GREEN_COLOR" "$DEFAULT_COLOR"
  
    fi
  fi
fi

admin_pass=$( < /dev/urandom tr -dc 'a-zA-Z0-9' | fold -w 20 | head -n 1 )

#INSTALL WORDPRESS:

wp core download --allow-root > /dev/null 2>&1
wp core config --dbname="$db_name" --dbuser="$db_name" --dbpass="$db_pass" --dbhost=localhost --dbprefix=wp_ --allow-root > /dev/null 2>&1
wp core install --url=https://"$input_domain" --title='My Blog' --admin_user='admin' --admin_password="$admin_pass" --admin_email=admin@"$domain_name" --allow-root > /dev/null 2>&1
  
#DEPLOY DEFAULT .HTACCESS FILE:

wget -q https://files.karev.eu/htaccess-wp 
mv htaccess-wp .htaccess 

#FIX PERMISSIONS:

find * .[^.]* -type d -print0 | xargs -0 chmod 0755 && find . -type f -print0 | xargs -0 chmod 0644

#FIX REWRITE BASE IF INSTALLATION IS IN A SUBFOLDER:

if [ ! -z "$sub_folder" ]; then

  new_path=$( echo /"${sub_folder}"/ | sed 's_/_\\/_g' )

  sed -i "s/RewriteBase \\//RewriteBase $new_path/" .htaccess
  sed -i "s/RewriteRule \\. \\//RewriteRule \\. $new_path/" .htaccess

fi

#FIX OWNERSHIP:
  
if [ "$current_user" = 'root' ]; then

  chown "${cpanel_user}": ./* .[^.]* -R

fi

printf "%sINSTALLATION COMPLETED.%s\\n" "$GREEN_COLOR" "$DEFAULT_COLOR"

#PRINT INSTALLATION DETAILS:

printf "%sINSTALLATION DETAILS:%s\\n" "$CYAN_COLOR" "$DEFAULT_COLOR"
printf "%sHOME PAGE URL: https://%s %s\\n" "$CYAN_COLOR" "$input_domain" "$DEFAULT_COLOR"
printf "%sADMIN DASHBOARD URL: https://%s/wp-admin %s\\n" "$CYAN_COLOR" "$input_domain" "$DEFAULT_COLOR"
printf "%sADMIN USERNAME: admin %s\\n" "$CYAN_COLOR" "$DEFAULT_COLOR"
printf "%sADMIN PASSWORD: $admin_pass %s\\n" "$CYAN_COLOR" "$DEFAULT_COLOR"
